/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.activityfolder;

import com.quantumdata.sct.comm.TEInterface;
import com.quantumdata.sct.gui.ComplianceTesterToolUI;
import com.quantumdata.sct.gui.activityfolder.ActivityFolder;
import com.quantumdata.sct.gui.activityfolder.HDCPResultFolder;
import com.quantumdata.sct.gui.common.MessageOptionPane;
import com.quantumdata.sct.gui.common.SCTButton;
import com.quantumdata.sct.gui.common.SCTComboBox;
import com.quantumdata.sct.gui.common.SCTConstants;
import com.quantumdata.sct.gui.common.SCTLabel;
import com.quantumdata.sct.gui.common.SCTPanel;
import com.quantumdata.sct.gui.common.SCTRadioButton;
import com.quantumdata.sct.gui.common.SCTTextField;
import com.quantumdata.sct.util.SCTSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;

public class HDCPDeclareFolder
extends ActivityFolder
implements ActionListener {
    private SCTRadioButton[] m_checkBoxes;
    private SCTPanel innerPanel;
    private SCTPanel innerPanel2;
    private SCTButton[] button;
    private HDCPResultFolder resultFolder;
    private SCTTextField[] m_textFields;
    private SCTTextField productName;
    String tempStr = "";
    String fileStr = "Unknown";

    public HDCPDeclareFolder(ComplianceTesterToolUI complianceTesterToolUI, HDCPResultFolder hDCPResultFolder) {
        super(complianceTesterToolUI, "Declare");
        this.init();
        this.resultFolder = hDCPResultFolder;
    }

    public void setProductName(String string) {
        this.productName.setText(string);
    }

    private void init() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setBackground(Color.white);
        this.m_checkBoxes = new SCTRadioButton[7];
        this.m_textFields = new SCTTextField[3];
        this.button = new SCTButton[3];
        this.m_checkBoxes[0] = new SCTRadioButton("Repeater_1.1_Features");
        this.m_checkBoxes[0].putClientProperty("Command", "RPFT");
        this.m_checkBoxes[1] = new SCTRadioButton("Source_Out_OnlyRep");
        this.m_checkBoxes[1].putClientProperty("Command", "SOOR");
        this.m_checkBoxes[2] = new SCTRadioButton("Repeater_Out_OnlyRep");
        this.m_checkBoxes[2].putClientProperty("Command", "ROOR");
        this.m_checkBoxes[3] = new SCTRadioButton("Sink_1.1_Features");
        this.m_checkBoxes[3].putClientProperty("Command", "SRFT");
        this.m_checkBoxes[4] = new SCTRadioButton("Repeater_Audio_Support");
        this.m_checkBoxes[4].putClientProperty("Command", "RPAS");
        this.m_checkBoxes[5] = new SCTRadioButton("Sink_Audio_Support");
        this.m_checkBoxes[5].putClientProperty("Command", "SNAS");
        this.m_checkBoxes[6] = new SCTRadioButton("Repeater_HPD_Pulse");
        this.m_checkBoxes[6].putClientProperty("Command", "RHPD");
        this.innerPanel = new SCTPanel(gridBagLayout);
        SCTComboBox sCTComboBox = new SCTComboBox();
        Dimension dimension = new Dimension(150, 40);
        String string = "DUT Type: ";
        sCTComboBox.putClientProperty("Command", "DUTT");
        sCTComboBox.addItem(new String(string + "Sink"));
        sCTComboBox.addItem(new String(string + "Source"));
        sCTComboBox.addItem(new String(string + "Repeater"));
        sCTComboBox.setFont(SCTConstants.SS_B_12);
        sCTComboBox.setBackground(Color.white);
        sCTComboBox.setMinimumSize(dimension);
        sCTComboBox.setPreferredSize(dimension);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        for (int i = 0; i < 7; ++i) {
            gridBagConstraints.gridx = i % 2 * 2;
            gridBagConstraints.gridy = i / 2;
            this.innerPanel.add((Component)this.m_checkBoxes[i], gridBagConstraints);
        }
        gridBagConstraints.gridx = 2;
        this.innerPanel.add((Component)sCTComboBox, gridBagConstraints);
        SCTLabel[] sCTLabelArray = new SCTLabel[]{new SCTLabel("Source_Max_KSV"), new SCTLabel("Repeater_Max_KSV"), new SCTLabel("Source_Authentication_Cnt")};
        this.m_textFields[0] = new SCTTextField("0");
        this.m_textFields[0].putClientProperty("Command", "SKSV");
        this.m_textFields[1] = new SCTTextField("0");
        this.m_textFields[1].putClientProperty("Command", "RKSV");
        this.m_textFields[2] = new SCTTextField("0");
        this.m_textFields[2].putClientProperty("Command", "SRAC");
        gridBagConstraints.gridwidth = 1;
        dimension = new Dimension(50, 30);
        for (int i = 0; i < 3; ++i) {
            gridBagConstraints.gridx = i % 2 * 2;
            gridBagConstraints.gridy = 4 + i / 2;
            sCTLabelArray[i].setFont(SCTConstants.SS_B_12);
            this.innerPanel.add((Component)sCTLabelArray[i], gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.m_textFields[i].setMinimumSize(dimension);
            this.m_textFields[i].setPreferredSize(dimension);
            this.innerPanel.add((Component)this.m_textFields[i], gridBagConstraints);
        }
        this.innerPanel2 = new SCTPanel();
        this.button[0] = new SCTButton("Send CDF to 882");
        this.button[0].addActionListener(this);
        this.innerPanel2.add(this.button[0]);
        this.button[1] = new SCTButton("Create Reports");
        this.button[1].addActionListener(this);
        this.innerPanel2.add(this.button[1]);
        this.button[2] = new SCTButton("Save Reports to Card");
        this.button[2].addActionListener(this);
        this.innerPanel2.add(this.button[2]);
        SCTSelection.instance().getUnitSerial();
        this.productName = new SCTTextField();
        this.innerPanel2.add(this.productName);
        this.innerPanel2.setLayout(new GridLayout(1, 4, 0, 0));
        this.innerPanel2.setSize(new Dimension(700, 50));
        this.innerPanel2.setPreferredSize(new Dimension(700, 50));
        this.innerPanel2.setMaximumSize(new Dimension(700, 50));
        JScrollPane jScrollPane = new JScrollPane(this.innerPanel, 22, 30);
        jScrollPane.setLayout(new ScrollPaneLayout());
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)jScrollPane, "North");
        this.add((Component)this.innerPanel2, "South");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (SCTSelection.instance().getCurrentConnection() == null) {
            MessageOptionPane.ShowErrorMessage(this, "No connection to the generator defined.  Please go to the Host menu.", "ERROR!");
            return;
        }
        TEInterface tEInterface = TEInterface.instance();
        if (!tEInterface.m_instrument.isConnected()) {
            return;
        }
        if (actionEvent.getSource() == this.button[0]) {
            for (int i = 0; i < this.innerPanel.getComponentCount(); ++i) {
                if (this.innerPanel.getComponent(i) instanceof SCTRadioButton) {
                    this.tempStr = ((SCTRadioButton)this.innerPanel.getComponent(i)).getClientProperty("Command") + " ";
                    this.tempStr = ((SCTRadioButton)this.innerPanel.getComponent(i)).isSelected() ? this.tempStr + "1" : this.tempStr + "0";
                } else if (this.innerPanel.getComponent(i) instanceof SCTComboBox) {
                    this.tempStr = ((SCTComboBox)this.innerPanel.getComponent(i)).getClientProperty("Command") + " " + ((SCTComboBox)this.innerPanel.getComponent(i)).getSelectedIndex();
                } else if (this.innerPanel.getComponent(i) instanceof SCTTextField) {
                    this.tempStr = ((SCTTextField)this.innerPanel.getComponent(i)).getClientProperty("Command") + " " + ((SCTTextField)this.innerPanel.getComponent(i)).getText();
                }
                if (this.tempStr.length() != 0) {
                    try {
                        tEInterface.setQuery("CPTX:" + this.tempStr);
                        tEInterface.sendCommand(true);
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        MessageOptionPane.ShowErrorMessage(this, "Exception " + exception.getMessage() + " occurred.", "ERROR!");
                    }
                }
                this.tempStr = "";
            }
            try {
                this.errorCheck(tEInterface);
            }
            catch (Exception exception) {
                MessageOptionPane.ShowErrorMessage(this, "Exception " + exception.getMessage() + " occurred.", "ERROR!");
            }
        }
        if (actionEvent.getSource() == this.button[1]) {
            try {
                tEInterface.setQuery("CPTX:CPTU");
                tEInterface.sendCommand(true);
                this.errorCheck(tEInterface);
                tEInterface.setQuery("*OPC?");
                tEInterface.sendCommand(true);
                this.resultFolder.switchURL("file:" + System.getProperty("user.dir") + System.getProperty("file.separator") + "/data/hdcp.htm");
            }
            catch (Exception exception) {
                MessageOptionPane.ShowErrorMessage(this, "Exception " + exception.getMessage() + " occurred.", "ERROR!");
            }
        }
        if (actionEvent.getSource() == this.button[2]) {
            for (int i = 0; i < this.innerPanel2.getComponentCount(); ++i) {
                if (!(this.innerPanel2.getComponent(i) instanceof SCTTextField)) continue;
                this.fileStr = ((SCTTextField)this.innerPanel2.getComponent(i)).getText();
            }
            try {
                String string = tEInterface.executeQueryWaitForResponse("UUTU?", 5);
                this.resultFolder.switchURL("http://" + SCTSelection.instance().getCurrentConnection().getName() + "/fs/reports/Hdcp_Compliance_" + string + ".html");
                tEInterface.setQuery("cp /Library/Reports/HDCP_Compliance_" + string + ".html /card0/" + this.fileStr + "Compliance.html");
                tEInterface.sendCommand(true);
                this.errorCheck(tEInterface);
            }
            catch (Exception exception) {
                MessageOptionPane.ShowErrorMessage(this, "Exception " + exception.getMessage() + " occurred.", "ERROR!");
            }
        }
    }

    public void errorCheck(TEInterface tEInterface) {
        String string = "";
        try {
            string = tEInterface.executeQueryWaitForResponse("ERRY?", 5);
        }
        catch (Exception exception) {
            MessageOptionPane.ShowErrorMessage(this, "Exception " + exception.getMessage() + " occurred.", "ERROR!");
        }
        if (Integer.parseInt(string) > 0) {
            this.printGeneratorError(Integer.parseInt(string));
            try {
                tEInterface.setQuery("ERRC");
                tEInterface.sendCommand(true);
            }
            catch (Exception exception) {
                MessageOptionPane.ShowErrorMessage(this, "Exception " + exception.getMessage() + " occurred.", "ERROR!");
            }
        }
    }

    public void printGeneratorError(int n) {
        String string = "Unknown error " + n + " occurred.  May not affect testing.";
        if (n == 1) {
            string = "Error!  Message sent to test equipment was not recognized!  (Error 1)";
        }
        if (n == 4) {
            string = "Error!  Message sent to test equipment had an invalid number of arguments! (Error 4)";
        }
        if (n == 6) {
            string = "Error!  File could not be used.  Please verify that a PCMCIA card is inserted and that software is up to date. (Error 6)";
        }
        if (n == 99) {
            string = "Internal error!  Please verify that a PCMCIA card is inserted and that software is up to date. (Error 99)";
        }
        if (n == 10031) {
            string = "Error!  Feature not enabled.  Please contact Quantum Data for licensing details. (Error 10031)";
        }
        if (n == 10300) {
            string = "CEC receive error - Message was not fully received. (Error 10300)";
        }
        if (n == 10301) {
            string = "CEC receive error - Timeout on the CEC line. (Error 10301)";
        }
        if (n == 10302) {
            string = "CEC receive error - Receive buffer error. (Error 10302)";
        }
        if (n == 10303) {
            string = "CEC receive error - Start bit timing incorrect. (Error 10303)";
        }
        if (n == 10304) {
            string = "CEC receive error - Receive buffer error - message dropped. (Error 10304)";
        }
        if (n == 10305) {
            string = "CEC receive error - Signal free time not adhered to. (Error 10305)";
        }
        if (n == 10310) {
            string = "CEC transmit error - CEC line error, send failed. (Error 10310)";
        }
        if (n == 10311) {
            string = "CEC transmit error - Arbitration was lost during send, send failed. (Error 10311)";
        }
        if (n == 10312) {
            string = "CEC transmit error - Message was not acknowledged.  Please retest. (Error 10312)";
        }
        if (n == 20000) {
            string = "Error!  Test equipment not connected to TME.  Please restart and connect.";
        }
        if (n == 20001) {
            string = "Error!  No value was entered by the tester when one was required!";
        }
        if (n == 20002) {
            string = "Error!  No selection was made by the tester when one was required!";
        }
        if (n == 20003) {
            string = "Error!  TME could not perform task (Exception occurred).";
        }
        if (n == 20005) {
            string = "Error!  Text input was not a number, when a number was expected.";
        }
        MessageOptionPane.ShowErrorMessage(this, string, "ERROR!");
    }
}

